/*
Antoine Maitre
http://digitalscience.free.fr/

Version 1.0, Released: 08/04/05

Code adapted from The Periodic Table v1.1 by C. Fennell (http://openscience.org/~chrisfen/)
*/

var element = new Array(118);
var elementSymbol = new Array(118);
var elementName = new Array(118);
var elementMass = new Array(118);
var symbolInfo;
var nameInfo;
var numberInfo;
var massInfo;
var phaseInfo;
var radioactInfo;
var y = 0;

for(y=0; y<118; y++){
	switch (y+1){
		case 1: elementSymbol[y] = 'H'; elementName[y] = 'Hydrogen';
			elementMass[y] = '1.01 g/mol'; break;
		case 2: elementSymbol[y] = 'He'; elementName[y] = 'Helium';
                        elementMass[y] = '4.00 g/mol'; break;
		case 3: elementSymbol[y] = 'Li'; elementName[y] = 'Lithium';
                        elementMass[y] = '[6.94] g/mol'; break;
		case 4: elementSymbol[y] = 'Be'; elementName[y] = 'Beryllium';
                        elementMass[y] = '9.01 g/mol'; break;
		case 5: elementSymbol[y] = 'B'; elementName[y] = 'Boron';
                        elementMass[y] = '10.81 g/mol'; break;
		case 6: elementSymbol[y] = 'C'; elementName[y] = 'Carbon';
                        elementMass[y] = '12.01 g/mol'; break;
		case 7: elementSymbol[y] = 'N'; elementName[y] = 'Nitrogen';
                        elementMass[y] = '14.01 g/mol'; break;
		case 8: elementSymbol[y] = 'O'; elementName[y] = 'Oxygen';
                        elementMass[y] = '16.00 g/mol'; break;
		case 9: elementSymbol[y] = 'F'; elementName[y] = 'Fluorine';
                        elementMass[y] = '19.00 g/mol'; break;
		case 10: elementSymbol[y] = 'Ne'; elementName[y] = 'Neon';
                        elementMass[y] = '20.17 g/mol'; break;
		case 11: elementSymbol[y] = 'Na'; elementName[y] = 'Sodium';
                        elementMass[y] = '22.99 g/mol'; break;
		case 12: elementSymbol[y] = 'Mg'; elementName[y] = 'Magnesium';
                        elementMass[y] = '24.31 g/mol'; break;
		case 13: elementSymbol[y] = 'Al'; elementName[y] = 'Aluminum';
                        elementMass[y] = '26.98 g/mol'; break;
		case 14: elementSymbol[y] = 'Si'; elementName[y] = 'Silicon';
                        elementMass[y] = '28.09 g/mol'; break;
		case 15: elementSymbol[y] = 'P'; elementName[y] = 'Phosphorus';
                        elementMass[y] = '30.97 g/mol'; break;
		case 16: elementSymbol[y] = 'S'; elementName[y] = 'Sulfur';
                        elementMass[y] = '32.07 g/mol'; break;
		case 17: elementSymbol[y] = 'Cl'; elementName[y] = 'Chlorine';
                        elementMass[y] = '35.45 g/mol'; break;
		case 18: elementSymbol[y] = 'Ar'; elementName[y] = 'Argon';
                        elementMass[y] = '39.95 g/mol'; break;
		case 19: elementSymbol[y] = 'K'; elementName[y] = 'Potassium';
                        elementMass[y] = '39.10 g/mol'; break;
		case 20: elementSymbol[y] = 'Ca'; elementName[y] = 'Calcium'
                        elementMass[y] = '40.08 g/mol'; break;
		case 21: elementSymbol[y] = 'Sc'; elementName[y] = 'Scandium';
                        elementMass[y] = '44.96 g/mol'; break;
		case 22: elementSymbol[y] = 'Ti'; elementName[y] = 'Titanium';
                        elementMass[y] = '47.87 g/mol'; break;
		case 23: elementSymbol[y] = 'V'; elementName[y] = 'Vanadium';
                        elementMass[y] = '50.94 g/mol'; break;
		case 24: elementSymbol[y] = 'Cr'; elementName[y] = 'Chromium';
                        elementMass[y] = '52.00 g/mol'; break;
		case 25: elementSymbol[y] = 'Mn'; elementName[y] = 'Manganese';
                        elementMass[y] = '54.94 g/mol'; break;
		case 26: elementSymbol[y] = 'Fe'; elementName[y] = 'Iron';
                        elementMass[y] = '55.85 g/mol'; break;
		case 27: elementSymbol[y] = 'Co'; elementName[y] = 'Cobalt';
                        elementMass[y] = '58.93 g/mol'; break;
		case 28: elementSymbol[y] = 'Ni'; elementName[y] = 'Nickel';
                        elementMass[y] = '58.69 g/mol'; break;
		case 29: elementSymbol[y] = 'Cu'; elementName[y] = 'Copper';
                        elementMass[y] = '63.55 g/mol'; break;
		case 30: elementSymbol[y] = 'Zn'; elementName[y] = 'Zinc';
                        elementMass[y] = '65.41 g/mol'; break;
		case 31: elementSymbol[y] = 'Ga'; elementName[y] = 'Gallium';
                        elementMass[y] = '69.72 g/mol'; break;
		case 32: elementSymbol[y] = 'Ge'; elementName[y] = 'Germanium';
                        elementMass[y] = '72.64 g/mol'; break;
		case 33: elementSymbol[y] = 'As'; elementName[y] = 'Arsenic';
                        elementMass[y] = '74.92 g/mol'; break;
		case 34: elementSymbol[y] = 'Se'; elementName[y] = 'Selenium';
                        elementMass[y] = '78.96 g/mol'; break;
		case 35: elementSymbol[y] = 'Br'; elementName[y] = 'Bromine';
                        elementMass[y] = '79.90 g/mol'; break;
		case 36: elementSymbol[y] = 'Kr'; elementName[y] = 'Krypton';
                        elementMass[y] = '83.80 g/mol'; break;
		case 37: elementSymbol[y] = 'Rb'; elementName[y] = 'Rubidium';
                        elementMass[y] = '85.47 g/mol'; break;
		case 38: elementSymbol[y] = 'Sr'; elementName[y] = 'Strontium';
                        elementMass[y] = '87.62 g/mol'; break;
		case 39: elementSymbol[y] = 'Y'; elementName[y] = 'Yttrium';
                        elementMass[y] = '88.91 g/mol'; break;
		case 40: elementSymbol[y] = 'Zr'; elementName[y] = 'Zirconium';
                        elementMass[y] = '91.22 g/mol'; break;
		case 41: elementSymbol[y] = 'Nb'; elementName[y] = 'Niobium';
                        elementMass[y] = '92.91 g/mol'; break;
		case 42: elementSymbol[y] = 'Mo'; elementName[y] = 'Molybdenum';
                        elementMass[y] = '95.94 g/mol'; break;
		case 43: elementSymbol[y] = 'Tc'; elementName[y] = 'Technetium*';
                        elementMass[y] = '[98] g/mol'; break;
		case 44: elementSymbol[y] = 'Ru'; elementName[y] = 'Ruthenium';
                        elementMass[y] = '101.07 g/mol'; break;
		case 45: elementSymbol[y] = 'Rh'; elementName[y] = 'Rhodium';
                        elementMass[y] = '102.91 g/mol'; break;
		case 46: elementSymbol[y] = 'Pd'; elementName[y] = 'Palladium';
                        elementMass[y] = '106.42 g/mol'; break;
		case 47: elementSymbol[y] = 'Ag'; elementName[y] = 'Silver';
                        elementMass[y] = '107.87 g/mol'; break;
		case 48: elementSymbol[y] = 'Cd'; elementName[y] = 'Cadmium';
                        elementMass[y] = '112.41 g/mol'; break;
		case 49: elementSymbol[y] = 'In'; elementName[y] = 'Indium';
                        elementMass[y] = '114.82 g/mol'; break;
		case 50: elementSymbol[y] = 'Sn'; elementName[y] = 'Tin';
                        elementMass[y] = '118.71 g/mol'; break;
		case 51: elementSymbol[y] = 'Sb'; elementName[y] = 'Antimony';
                        elementMass[y] = '121.76 g/mol'; break;
		case 52: elementSymbol[y] = 'Te'; elementName[y] = 'Tellurium';
                        elementMass[y] = '127.60 g/mol'; break;
		case 53: elementSymbol[y] = 'I'; elementName[y] = 'Iodine';
                        elementMass[y] = '126.90 g/mol'; break;
		case 54: elementSymbol[y] = 'Xe'; elementName[y] = 'Xenon';
                        elementMass[y] = '131.29 g/mol'; break;
		case 55: elementSymbol[y] = 'Cs'; elementName[y] = 'Caesium';
                        elementMass[y] = '132.91 g/mol'; break;
		case 56: elementSymbol[y] = 'Ba'; elementName[y] = 'Barium';
                        elementMass[y] = '137.33 g/mol'; break;
		case 57: elementSymbol[y] = 'La'; elementName[y] = 'Lanthanum';
                        elementMass[y] = '138.91 g/mol'; break;
		case 58: elementSymbol[y] = 'Ce'; elementName[y] = 'Cerium';
                        elementMass[y] = '140.12 g/mol'; break;
		case 59: elementSymbol[y] = 'Pr'; elementName[y] = 'Praseodymium';
                        elementMass[y] = '140.91 g/mol'; break;
		case 60: elementSymbol[y] = 'Nd'; elementName[y] = 'Neodymium';
                        elementMass[y] = '144.24 g/mol'; break;
		case 61: elementSymbol[y] = 'Pm'; elementName[y] = 'Promethium*';
                        elementMass[y] = '[145] g/mol'; break;
		case 62: elementSymbol[y] = 'Sm'; elementName[y] = 'Samarium';
                        elementMass[y] = '150.36 g/mol'; break;
		case 63: elementSymbol[y] = 'Eu'; elementName[y] = 'Europium';
                        elementMass[y] = '151.96 g/mol'; break;
		case 64: elementSymbol[y] = 'Gd'; elementName[y] = 'Gadolinium';
                        elementMass[y] = '157.25 g/mol'; break;
		case 65: elementSymbol[y] = 'Tb'; elementName[y] = 'Terbium';
                        elementMass[y] = '158.93 g/mol'; break;
		case 66: elementSymbol[y] = 'Dy'; elementName[y] = 'Dysprosium';
                        elementMass[y] = '162.50 g/mol'; break;
		case 67: elementSymbol[y] = 'Ho'; elementName[y] = 'Holmium';
                        elementMass[y] = '164.93 g/mol'; break;
		case 68: elementSymbol[y] = 'Er'; elementName[y] = 'Erbium';
                        elementMass[y] = '167.26 g/mol'; break;
		case 69: elementSymbol[y] = 'Tm'; elementName[y] = 'Thulium';
                        elementMass[y] = '168.93 g/mol'; break;
		case 70: elementSymbol[y] = 'Yb'; elementName[y] = 'Ytterbium';
                        elementMass[y] = '173.04 g/mol'; break;
		case 71: elementSymbol[y] = 'Lu'; elementName[y] = 'Lutetium';
                        elementMass[y] = '174.97 g/mol'; break;
		case 72: elementSymbol[y] = 'Hf'; elementName[y] = 'Hafnium';
                        elementMass[y] = '178.49 g/mol'; break;
		case 73: elementSymbol[y] = 'Ta'; elementName[y] = 'Tantalum';
                        elementMass[y] = '180.95 g/mol'; break;
		case 74: elementSymbol[y] = 'W'; elementName[y] = 'Tungsten';
                        elementMass[y] = '183.84 g/mol'; break;
		case 75: elementSymbol[y] = 'Re'; elementName[y] = 'Rhenium';
                        elementMass[y] = '186.21 g/mol'; break;
		case 76: elementSymbol[y] = 'Os'; elementName[y] = 'Osmium';
                        elementMass[y] = '190.23 g/mol'; break;
		case 77: elementSymbol[y] = 'Ir'; elementName[y] = 'Iridium';
                        elementMass[y] = '192.22 g/mol'; break;
		case 78: elementSymbol[y] = 'Pt'; elementName[y] = 'Platinum';
                        elementMass[y] = '195.08 g/mol'; break;
		case 79: elementSymbol[y] = 'Au'; elementName[y] = 'Gold';
                        elementMass[y] = '196.97 g/mol'; break;
		case 80: elementSymbol[y] = 'Hg'; elementName[y] = 'Mercury';
                        elementMass[y] = '200.59 g/mol'; break;
		case 81: elementSymbol[y] = 'Tl'; elementName[y] = 'Thallium';
                        elementMass[y] = '204.38 g/mol'; break;
		case 82: elementSymbol[y] = 'Pb'; elementName[y] = 'Lead';
                        elementMass[y] = '207.2 g/mol'; break;
		case 83: elementSymbol[y] = 'Bi'; elementName[y] = 'Bismuth';
                        elementMass[y] = '208.98 g/mol'; break;
		case 84: elementSymbol[y] = 'Po'; elementName[y] = 'Polonium*';
                        elementMass[y] = '[209] g/mol'; break;
		case 85: elementSymbol[y] = 'At'; elementName[y] = 'Astatine*';
                        elementMass[y] = '[210] g/mol'; break;
		case 86: elementSymbol[y] = 'Rn'; elementName[y] = 'Radon*';
                        elementMass[y] = '[222] g/mol'; break;
		case 87: elementSymbol[y] = 'Fr'; elementName[y] = 'Francium*';
                        elementMass[y] = '[223] g/mol'; break;
		case 88: elementSymbol[y] = 'Ra'; elementName[y] = 'Radium*';
                        elementMass[y] = '[226] g/mol'; break;
		case 89: elementSymbol[y] = 'Ac'; elementName[y] = 'Actinium*';
                        elementMass[y] = '[227] g/mol'; break;
		case 90: elementSymbol[y] = 'Th'; elementName[y] = 'Thorium*';
                        elementMass[y] = '232.04 g/mol'; break;
		case 91: elementSymbol[y] = 'Pa'; elementName[y] = 'Protactinium*';
                        elementMass[y] = '231.04 g/mol'; break;
		case 92: elementSymbol[y] = 'U'; elementName[y] = 'Uranium*';
                        elementMass[y] = '238.03 g/mol'; break;
		case 93: elementSymbol[y] = 'Np'; elementName[y] = 'Neptunium*';
                        elementMass[y] = '[237] g/mol'; break;
		case 94: elementSymbol[y] = 'Pu'; elementName[y] = 'Plutonium*';
                        elementMass[y] = '[244] g/mol'; break;
		case 95: elementSymbol[y] = 'Am'; elementName[y] = 'Americium*';
                        elementMass[y] = '[243] g/mol'; break;
		case 96: elementSymbol[y] = 'Cm'; elementName[y] = 'Curium*';
                        elementMass[y] = '[247] g/mol'; break;
		case 97: elementSymbol[y] = 'Bk'; elementName[y] = 'Berkelium*';
                        elementMass[y] = '[247] g/mol'; break;
		case 98: elementSymbol[y] = 'Cf'; elementName[y] = 'Californium*';
                        elementMass[y] = '[251] g/mol'; break;
		case 99: elementSymbol[y] = 'Es'; elementName[y] = 'Einsteinium*';
                        elementMass[y] = '[252] g/mol'; break;
		case 100: elementSymbol[y] = 'Fm'; elementName[y] = 'Fermium*';
                        elementMass[y] = '[257] g/mol'; break;
		case 101: elementSymbol[y] = 'Md'; elementName[y] = 'Mendelevium*';
                        elementMass[y] = '[258] g/mol'; break;
		case 102: elementSymbol[y] = 'No'; elementName[y] = 'Nobelium*';
                        elementMass[y] = '[259] g/mol'; break;
		case 103: elementSymbol[y] = 'Lr'; elementName[y] = 'Lawrencium*';
                        elementMass[y] = '[262] g/mol'; break;
		case 104: elementSymbol[y] = 'Rf'; elementName[y] = 'Rutherfordium*';
                        elementMass[y] = '[261] g/mol'; break;
		case 105: elementSymbol[y] = 'Db'; elementName[y] = 'Dubnium*';
                        elementMass[y] = '[262] g/mol'; break;
		case 106: elementSymbol[y] = 'Sg'; elementName[y] = 'Seaborgium*';
                        elementMass[y] = '[266] g/mol'; break;
		case 107: elementSymbol[y] = 'Bh'; elementName[y] = 'Bohrium*';
                        elementMass[y] = '[264] g/mol'; break;
		case 108: elementSymbol[y] = 'Hs'; elementName[y] = 'Hassium*';
                        elementMass[y] = '[277] g/mol'; break;
		case 109: elementSymbol[y] = 'Mt'; elementName[y] = 'Meitnerium*';
                        elementMass[y] = '[268] g/mol'; break;
		case 110: elementSymbol[y] = 'Ds'; elementName[y] = 'Darmstadtium*';
                        elementMass[y] = '[281] g/mol'; break;
		case 111: elementSymbol[y] = 'Rg'; elementName[y] = 'Roentgenium*';
                        elementMass[y] = '[272] g/mol'; break;
		case 112: elementSymbol[y] = 'Uub'; elementName[y] = 'Ununbium*';
                        elementMass[y] = '[285] g/mol'; break;
		case 113: elementSymbol[y] = 'Uut'; elementName[y] = 'Ununtrium*';
                        elementMass[y] = '[284]? g/mol'; break;
		case 114: elementSymbol[y] = 'Uuq'; elementName[y] = 'Ununquadium*';
                        elementMass[y] = '[289] g/mol'; break;
		case 115: elementSymbol[y] = 'Uup'; elementName[y] = 'Ununpentium*';
                        elementMass[y] = '[288]? g/mol'; break;
		case 116: elementSymbol[y] = 'Uuh'; elementName[y] = 'Ununhexium*';
                        elementMass[y] = '[292]? g/mol'; break;
		case 117: elementSymbol[y] = 'Uus'; elementName[y] = 'Ununseptium*';
                        elementMass[y] = '[291]? g/mol'; break;
		case 118: elementSymbol[y] = 'Uuo'; elementName[y] = 'Ununoctium*';
                        elementMass[y] = '[293]? g/mol'; break;
	}
}

function clearTable (event){
	for (y=0; y<118; y++){
		element[y] = document.getElementById('number'+(y+1));
		switch (y+1){
	        case 1: element[y].src = 'images/clear.png'; break;
        	case 2: element[y].src = 'images/clear.png'; break;
			case 3: element[y].src = 'images/clear.png'; break;
			case 4: element[y].src = 'images/clear.png'; break;
			case 5: element[y].src = 'images/clear.png'; break;
			case 6: element[y].src = 'images/clear.png'; break;
			case 7: element[y].src = 'images/clear.png'; break;
			case 8: element[y].src = 'images/clear.png'; break;
			case 9: element[y].src = 'images/clear.png'; break;
			case 10: element[y].src = 'images/clear.png'; break;
			case 11: element[y].src = 'images/clear.png'; break;
			case 12: element[y].src = 'images/clear.png'; break;
			case 13: element[y].src = 'images/clear.png'; break;
			case 14: element[y].src = 'images/clear.png'; break;
			case 15: element[y].src = 'images/clear.png'; break;
			case 16: element[y].src = 'images/clear.png'; break;
			case 17: element[y].src = 'images/clear.png'; break;
			case 18: element[y].src = 'images/clear.png'; break;
			case 19: element[y].src = 'images/clear.png'; break;
			case 20: element[y].src = 'images/clear.png'; break;
			case 21: element[y].src = 'images/clear.png'; break;
			case 22: element[y].src = 'images/clear.png'; break;
			case 23: element[y].src = 'images/clear.png'; break;
			case 24: element[y].src = 'images/clear.png'; break;
			case 25: element[y].src = 'images/clear.png'; break;
			case 26: element[y].src = 'images/clear.png'; break;
			case 27: element[y].src = 'images/clear.png'; break;
			case 28: element[y].src = 'images/clear.png'; break;
			case 29: element[y].src = 'images/clear.png'; break;
			case 30: element[y].src = 'images/clear.png'; break;
			case 31: element[y].src = 'images/clear.png'; break;
			case 32: element[y].src = 'images/clear.png'; break;
			case 33: element[y].src = 'images/clear.png'; break;
			case 34: element[y].src = 'images/clear.png'; break;
			case 35: element[y].src = 'images/clear.png'; break;
			case 36: element[y].src = 'images/clear.png'; break;
			case 37: element[y].src = 'images/clear.png'; break;
			case 38: element[y].src = 'images/clear.png'; break;
			case 39: element[y].src = 'images/clear.png'; break;
			case 40: element[y].src = 'images/clear.png'; break;
			case 41: element[y].src = 'images/clear.png'; break;
			case 42: element[y].src = 'images/clear.png'; break;
			case 43: element[y].src = 'images/clear.png'; break;
			case 44: element[y].src = 'images/clear.png'; break;
			case 45: element[y].src = 'images/clear.png'; break;
			case 46: element[y].src = 'images/clear.png'; break;
			case 47: element[y].src = 'images/clear.png'; break;
			case 48: element[y].src = 'images/clear.png'; break;
			case 49: element[y].src = 'images/clear.png'; break;
			case 50: element[y].src = 'images/clear.png'; break;
			case 51: element[y].src = 'images/clear.png'; break;
			case 52: element[y].src = 'images/clear.png'; break;
			case 53: element[y].src = 'images/clear.png'; break;
			case 54: element[y].src = 'images/clear.png'; break;
			case 55: element[y].src = 'images/clear.png'; break;
			case 56: element[y].src = 'images/clear.png'; break;
			case 57: element[y].src = 'images/clear.png'; break;
			case 58: element[y].src = 'images/clear.png'; break;
			case 59: element[y].src = 'images/clear.png'; break;
			case 60: element[y].src = 'images/clear.png'; break;
			case 61: element[y].src = 'images/clear.png'; break;
			case 62: element[y].src = 'images/clear.png'; break;
			case 63: element[y].src = 'images/clear.png'; break;
			case 64: element[y].src = 'images/clear.png'; break;
			case 65: element[y].src = 'images/clear.png'; break;
			case 66: element[y].src = 'images/clear.png'; break;
			case 67: element[y].src = 'images/clear.png'; break;
			case 68: element[y].src = 'images/clear.png'; break;
			case 69: element[y].src = 'images/clear.png'; break;
			case 70: element[y].src = 'images/clear.png'; break;
			case 71: element[y].src = 'images/clear.png'; break;
			case 72: element[y].src = 'images/clear.png'; break;
			case 73: element[y].src = 'images/clear.png'; break;
			case 74: element[y].src = 'images/clear.png'; break;
			case 75: element[y].src = 'images/clear.png'; break;
			case 76: element[y].src = 'images/clear.png'; break;
			case 77: element[y].src = 'images/clear.png'; break;
			case 78: element[y].src = 'images/clear.png'; break;
			case 79: element[y].src = 'images/clear.png'; break;
			case 80: element[y].src = 'images/clear.png'; break;
			case 81: element[y].src = 'images/clear.png'; break;
			case 82: element[y].src = 'images/clear.png'; break;
			case 83: element[y].src = 'images/clear.png'; break;
			case 84: element[y].src = 'images/clear.png'; break;
			case 85: element[y].src = 'images/clear.png'; break;
			case 86: element[y].src = 'images/clear.png'; break;
			case 87: element[y].src = 'images/clear.png'; break;
			case 88: element[y].src = 'images/clear.png'; break;
			case 89: element[y].src = 'images/clear.png'; break;
			case 90: element[y].src = 'images/clear.png'; break;
			case 91: element[y].src = 'images/clear.png'; break;
			case 92: element[y].src = 'images/clear.png'; break;
			case 93: element[y].src = 'images/clear.png'; break;
			case 94: element[y].src = 'images/clear.png'; break;
			case 95: element[y].src = 'images/clear.png'; break;
			case 96: element[y].src = 'images/clear.png'; break;
			case 97: element[y].src = 'images/clear.png'; break;
			case 98: element[y].src = 'images/clear.png'; break;
			case 99: element[y].src = 'images/clear.png'; break;
			case 100: element[y].src = 'images/clear.png'; break;
			case 101: element[y].src = 'images/clear.png'; break;
			case 102: element[y].src = 'images/clear.png'; break;
			case 103: element[y].src = 'images/clear.png'; break;
			case 104: element[y].src = 'images/clear.png'; break;
			case 105: element[y].src = 'images/clear.png'; break;
			case 106: element[y].src = 'images/clear.png'; break;
			case 107: element[y].src = 'images/clear.png'; break;
			case 108: element[y].src = 'images/clear.png'; break;
			case 109: element[y].src = 'images/clear.png'; break;
			case 110: element[y].src = 'images/clear.png'; break;
			case 111: element[y].src = 'images/clear.png'; break;
			case 112: element[y].src = 'images/clear.png'; break;
			case 113: element[y].src = 'images/clear.png'; break;
			case 114: element[y].src = 'images/clear.png'; break;
			case 115: element[y].src = 'images/clear.png'; break;
			case 116: element[y].src = 'images/clear.png'; break;
			case 117: element[y].src = 'images/clear.png'; break;
			case 118: element[y].src = 'images/clear.png'; break;
		}
	}
}

function buttonSelect (elementNum){
	clearTable();
	y = elementNum - 1;
	element[y] = document.getElementById('number'+(y+1));
	element[y].src = 'images/'+(y+1)+'_s.png';
	
	symbolInfo = document.getElementById('symbolFont');
	switch (elementNum){
		case 1: gasPhase(elementNum); symbolInfo.style.color = 'white'; 
			element[y].src = 'images/select.png'; break;
		case 2: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 3: solidPhase(elementNum); symbolInfo.style.color = 'white'; 
			element[y].src = 'images/select.png'; break;
		case 4: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 5: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 6: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 7: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 8: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 9: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 10: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 11: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 12: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 13: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 14: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 15: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 16: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 17: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 18: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 19: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 20: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 21: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 22: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 23: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 24: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 25: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 26: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 27: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 28: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 29: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 30: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 31: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 32: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 33: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 34: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 35: liquidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 36: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 37: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 38: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 39: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 40: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 41: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 42: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 43: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 44: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 45: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 46: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 47: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 48: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 49: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 50: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 51: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 52: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 53: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 54: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 55: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 56: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 57: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 58: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 59: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 60: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 61: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 62: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 63: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 64: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 65: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 66: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 67: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 68: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 69: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 70: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 71: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 72: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 73: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 74: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 75: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 76: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 77: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 78: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 79: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 80: liquidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 81: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 82: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 83: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 84: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 85: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 86: gasPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 87: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 88: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 89: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 90: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 91: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 92: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 93: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 94: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 95: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 96: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 97: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 98: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 99: solidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 100: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 101: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 102: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 103: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 104: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 105: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 106: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 107: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 108: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 109: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 110: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 111: ssolidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 112: sliquidPhase(elementNum); symbolInfo.style.color = 'white';
			element[y].src = 'images/select.png'; break;
		case 113: ssolidPhase(elementNum); symbolInfo.style.color = 'gray';
			element[y].src = 'images/select.png'; break;
		case 114: ssolidPhase(elementNum); symbolInfo.style.color = 'gray';
			element[y].src = 'images/select.png'; break;
		case 115: ssolidPhase(elementNum); symbolInfo.style.color = 'gray';
			element[y].src = 'images/select.png'; break;
		case 116: ssolidPhase(elementNum); symbolInfo.style.color = 'gray';
			element[y].src = 'images/select.png'; break;
		case 117: ssolidPhase(elementNum); symbolInfo.style.color = 'gray';
			element[y].src = 'images/select.png'; break;
		case 118: sgasPhase(elementNum); symbolInfo.style.color = 'gray';
			element[y].src = 'images/select.png'; break;
	}
	symbolInfo.innerHTML = elementSymbol[y];
	nameInfo = document.getElementById('nameFont').innerHTML = elementName[y];
	numberInfo = document.getElementById('numberFont').innerHTML = y+1;
	massInfo = document.getElementById('massFont').innerHTML = elementMass[y];
}

function solidPhase(elementNum){
	phaseInfo = document.getElementById('phase');
	phaseInfo.src = "images/solid.png";
}

function ssolidPhase(elementNum){
	phaseInfo = document.getElementById('phase');
	phaseInfo.src = "images/s-solid.png";
}

function liquidPhase(elementNum){
	phaseInfo = document.getElementById('phase');
	phaseInfo.src = "images/liquid.png";
}

function sliquidPhase(elementNum){
	phaseInfo = document.getElementById('phase');
	phaseInfo.src = "images/s-liquid.png";
}

function gasPhase(elementNum){
	phaseInfo = document.getElementById('phase');
	phaseInfo.src = "images/gas.png";
}

function sgasPhase(elementNum){
	phaseInfo = document.getElementById('phase');
	phaseInfo.src = "images/s-gas.png";
}

function radioactive(elementNum){
	radioactInfo = document.getElementById('radioactivity');
	radioactInfo.src = "images/radioactive.tiff";
}

function goToHome(){
	widget.openURL('http://digitalscience.free.fr/');
}

function goToElementsHome(){
	widget.openURL('http://digitalscience.free.fr/elements/download.html');
}

function clicked(){
        if (widget)
        {
            widget.openApplication('fr.ds.elements');
        }
        else
        {
        	widget.openURL('http://digitalscience.free.fr/elements/download.html');
        }
}