var gHoursDiv;
var gHours;
var gMinutesDiv;
var gMinutes;
var gSecondsDiv;
var gSeconds;
var gStartDiv;
var gStopDiv;
var gTimer;
var gFullTime;
var gSettingFullTime;

function init() {
  gHoursDiv = document.getElementById("hours");
  gMinutesDiv = document.getElementById("minutes");
  gSecondsDiv = document.getElementById("seconds");

  gStartDiv = document.getElementById("start");
  gStopDiv = document.getElementById("stop");
  
  gHours = gMinutes = gSeconds = 0;

  gTimer = 0;

  gFullTime = 0;
  gSettingFullTime = true;

  document.onkeydown = OnKeyDown;
  ResetKeyInput();

  stop();
  
  update();
}

var gKeyInput;
var gKeyTimer;

function OnKeyDown(e) {
  if (!gTimer) {
    var code;
    if (window.event) {
      code = window.event.keyCode;
    } else {
      code = e.which;
    }
    var value = -1;
    if (code >= 48 && code <= 57) {
      value = code - 48;
    } else if (code >= 96 && code <= 105) {
      value = code - 96;
    }
    if (value > -1) {
      if (gKeyTimer) {
	clearTimeout(gKeyTimer);
	gKeyTimer = 0;
      }
      gKeyInput += value;
      SetTimeFromKeyInput();
      gKeyTimer = setTimeout("ResetKeyInput()", 3000);
    } else if (code == 13 || code == 32) {
      if (gTimer) {
	stop();
      } else {
	start();
      }
    }
  }
}

function ResetKeyInput() {
  if (gKeyTimer) {
    clearTimeout(gKeyTimer);
  }
  gKeyTimer = 0;
  gKeyInput = "000000";
  FinalizeTime();
}

function SetTimeFromKeyInput() {
  var offset = gKeyInput.length - 6;
  gHours = parseInt(gKeyInput.substring(offset, offset+2));
  gMinutes = parseInt(gKeyInput.substring(offset+2, offset+4));
  gSeconds = parseInt(gKeyInput.substring(offset+4, offset+6));

  update();
}

function StoreFullTime() {
	gFullTime = ((gHours*60) + gMinutes)*60 + gSeconds;
}

function RestoreFullTime() {
	gSeconds = gFullTime;
	FinalizeTime();
	update();
}

function FinalizeTime() {
  var needsUpdate = false;
  while (gSeconds > 59) {
    gSeconds -= 60;
    gMinutes++;
    needsUpdate = true;
  }
  while (gMinutes > 59) {
    gMinutes -= 60;
    gHours++;
    needsUpdate = true;
  }
  if (gHours > 99) {
    gHours = 99;
  }

  if (needsUpdate) {
    update();
  }
}

function update() {
  var text;

  text = ((gHours < 10) ? "0" : "") + gHours;
  gHoursDiv.firstChild.data = text;

  text = ((gMinutes < 10) ? "0" : "") + gMinutes;
  gMinutesDiv.firstChild.data = text;

  text = ((gSeconds < 10) ? "0" : "") + gSeconds;
  gSecondsDiv.firstChild.data = text;

  if (gSettingFullTime) {
	  StoreFullTime();
  }
}

function incHours() {
	if (gHours < 12) {
		gHours++;
	}
	update();
}

function decHours() {
	if (gHours > 0) {
		gHours--;
	}
	update();
}

function incMinutes() {
	if (gMinutes < 59) {
		gMinutes++;
	} else {
		gMinutes = 0;
		incHours();
	}
	update();
}

function decMinutes() {
	if (gMinutes > 0) {
		gMinutes--;
	}
	update();
}

function incSeconds() {
	if (gSeconds < 59) {
		gSeconds++;
	} else {
		gSeconds = 0;
		incMinutes();
	}
	update();
}

function decSeconds() {
	if (gSeconds > 0) {
		gSeconds--;
	}
	update();
}

function tick() {
	if (gSeconds > 0) {
		gSeconds--;
	} else if (gMinutes > 0) {
		gMinutes--;
		gSeconds = 59;
	} else if (gHours > 0) {
		gHours--;
		gMinutes = 59;
		gSeconds = 59;
	} else {
		stop();
		RestoreFullTime();
		document.getElementById("alarm").play();
		return;
	}

	update();
}
		

function start() {
	if (!gTimer) {
		gSettingFullTime = false;
		ResetKeyInput();
		gTimer = setInterval("tick()", 1000);
		gStartDiv.style.display = "none";
		gStopDiv.style.display = "block";
	}
}

function stop() {
	if (gTimer) {
		clearInterval(gTimer);
		gTimer = 0;
	}
	gStartDiv.style.display = "block";
	gStopDiv.style.display = "none";
	gSettingFullTime = true;
}

