/*
 ****************************************************
 * ELIZA WIDGET BY LORENZ SCHORI
 *  
 * ELIZA WAS ORIGINALLY WRITTEN BY JOSEPH WEIZENBAUM
 * IN 1966. PARTS OF THIS IMPLEMENTATION ARE BASED ON
 * JAVASCRIPT ELIZA WRITTEN BY GEORGE DUNLOP 
 * AND MICHAEL WALLACE.
 ****************************************************
 */


/*
 ****************************************************
 * GLOBALS + KEY CLASS
 ****************************************************
 */

var loaded = false;

// this is the array where entries are stored into
entries = new Array;

// add a reply to an entry and return new length
function addReply(response) {
	return this.replys.push(response);
}

// entry constructor. keys must be an array of strings
function entry(keys){
	this.keys = keys;
	this.replys = new Array;
	this.last = -1;
	this.addReply = addReply;
}

// 
function getKey() {
	// check bounds
	if (!this.entryIdx >= entries.length ||
			!this.entryIdx < 0 || 
			!this.keyIdx >= entries[this.entryIdx].keys.length ||
			!this.keyIdx < 0)
	{
		return "";
	}
	return entries[this.entryIdx].keys[this.keyIdx];
}

function getReply() {
	// check bounds
	if (this.entryIdx >= entries.length ||
			this.entryIdx < 0 || 
			this.replyIdx >= entries[this.entryIdx].replys.length ||
			this.replyIdx < 0)
	{
		return "";
	}
	return entries[this.entryIdx].replys[this.replyIdx];
}

function randomizeReply() {
	// check bounds
	if (this.entryIdx >= entries.length || this.entryIdx < 0) {
		return;
	}
	
	var pass = 0;
	var choice = 0;
	
	totReplys = entries[this.entryIdx].replys.length;
	lastReply = entries[this.entryIdx].last;
	this.replyIdx = lastReply;
	do {
		pass++;
		this.replyIdx = Math.floor( Math.random() * totReplys);
							
	} while(this.replyIdx == lastReply && pass < totReplys)
	entries[this.entryIdx].last = this.replyIdx;
}


function entryRef(entryIdx,keyIdx) {
	this.entryIdx = entryIdx;
	this.keyIdx = keyIdx;
	this.replyIdx = 0;
	this.getKey = getKey;
	this.getReply = getReply;
	this.randomizeReply = randomizeReply;
}

// find a key in the entries array and return it's index
function findKey(wString){ 
	entry = -1;
	
	for(i=0; i < entries.length; i++) {
		for(j=0; j < entries[i].keys.length; j++) {
			if (wString.indexOf( " " + entries[i].keys[j] + " ") >= 0 ) {
				entry = new entryRef(i,j);
				break;
			}		
		}	
	}
	return entry;
}

 var conj1 = new Array;
 var conj2 = new Array;
 var conj3 = new Array;
 var conj4 = new Array;
 
 
/*
 ****************************************************
 * STRING HELPERS
 ****************************************************
 */

/*
 ****************************************************
 * replaceStr(string, substr1, substr2, type)
 * Funtion to replaces all occurances of substring
 * substr1 with substr2 within strng
 * if type == 0 straight string replacement
 * if type == 1 assumes padded strings and replaces 
 *              whole words only
 * if type == 2 non case sensitive assumes padded
 *              strings to compare whole word only
 * if type == 3 non case sensitive straight string
 *              replacement
 ****************************************************
 */

var RPstrg = "";
function replaceStr( strng, substr1, substr2, type){
	var pntr = -1; aString = strng;
	if ( type == 0 ) {  
		if( strng.indexOf( substr1 ) >= 0 ) {
			pntr = strng.indexOf( substr1 );
		}
	}
	else if( type == 1 ) {
		if( strng.indexOf( " "+ substr1 +" " ) >= 0 ) {
			pntr = strng.indexOf( " " + substr1 + " " ) + 1;
		}	
	}
	else if( type == 2 ) {
		bstrng = strng.toUpperCase();
		bsubstr1 = substr1.toUpperCase();
		if ( bstrng.indexOf( " "+ bsubstr1 +" " )>= 0 ) {
			pntr = bstrng.indexOf( " " + bsubstr1 + " " ) + 1;
		}	
	}
	else {
		bstrng = strng.toUpperCase();
		bsubstr1 = substr1.toUpperCase();
		if( bstrng.indexOf( bsubstr1 ) >= 0 ) {
			pntr = bstrng.indexOf( bsubstr1 );
		}
	}
	if ( pntr >= 0 ) {
		RPstrg += strng.substring( 0, pntr ) + substr2;
		aString = strng.substring(pntr + substr1.length, strng.length );
		if( aString.length > 0 ) {
			replaceStr( aString, substr1, substr2, type );
		}
	}
	aString =  RPstrg + aString;
	RPstrg = "";
	return aString;
}	


/*
 ****************************************************
 * padString(string):
 * break string into words and separate them from
 * punctuation chars.
 ****************************************************
 */
punct = new Array(".", ",", "!", "?", ":", ";", "&", '"', "@", "#", "(", ")" )
function padString(strng) {
	aString = " " + strng + " ";
	for( i=0; i < punct.length; i++ ) {
		aString = replaceStr( aString, punct[i], " " + punct[i] + " ", 0 );
	}
	return aString
}

/*
 ****************************************************
 * unpadString(string):
 * reassemble string and eliminate double space
 * chars.
 ****************************************************
 */
function unpadString(strng) {
	aString = strng;
	aString = replaceStr( aString, "  ", " ", 0 ); 		// compress spaces
	if( strng.charAt( 0 ) == " " ) {
		aString = aString.substring(1, aString.length );
	}
	if( strng.charAt( aString.length - 1 ) == " " ) {
		aString = aString.substring(0, aString.length - 1 );
	}
	for( i=0; i < punct.length; i++ ) {
		aString = replaceStr( aString, " " + punct[i], punct[i], 0 );
	}
	return aString
}


/*
 ****************************************************
 * strTrim(string):
 * dress input string (spaces punctuation).
 ****************************************************
 */
var ht = 0;												// head tail stearing
function strTrim(strng) {
	if(ht == 0){
		loc = 0;
	}
	else {
		loc = strng.length - 1;
	}						// tail clip  ht = 1 
	
	if( strng.charAt( loc ) == " "){
		aString = strng.substring( - ( ht - 1 ), strng.length - ht);
		aString = strTrim(aString);
	} else { 
		var flg = false;
		for(i=0; i<=5; i++ ){ flg = flg || ( strng.charAt( loc ) == punct[i]); }
		if(flg){	
			aString = strng.substring( - ( ht - 1 ), strng.length - ht );
		} else { aString = strng; }
		if(aString != strng ){ strTrim(aString); }
	}
	if( ht ==0 ){ ht = 1; strTrim(aString); } 
	else { ht = 0; }		
	return aString;
}

/*
 ****************************************************
 * conjugate(string)
 ****************************************************
 */
function conjugate( sStrg ){           			// rephrases sString
	var sString = sStrg;
	for( i = 0; i < conj1.length; i++ ){			// decompose
		sString = replaceStr( sString, conj1[i], "#@&" + i, 2 );
	}
	for( i = 0; i < conj2.length; i++ ){			// recompose
		sString = replaceStr( sString, "#@&" + i, conj2[i], 2 );
	}
	// post process the resulting string
	for( i = 0; i < conj3.length; i++ ){			// decompose
		sString = replaceStr( sString, conj3[i], "#@&" + i, 2 );
	}
	for( i = 0; i < conj4.length; i++ ){			// recompose
		sString = replaceStr( sString, "#@&" + i, conj4[i], 2 );
	}
	return sString;
}

/*
 ****************************************************
 * phrase(string, keyidx):
 * build response string according to the found key
 ****************************************************
 */
function phrase( sString, repref ){
	repref.randomizeReply();
	var rTemp = repref.getReply();
	var tempt = rTemp.charAt( rTemp.length - 1 );
	
	if(( tempt == "*" ) || ( tempt == "@" )){
		var thisstr = "";
		var sTemp = padString(sString);
		var wTemp = sTemp.toUpperCase();
		var sKey = repref.getKey();
		
		var strpstr = wTemp.indexOf( " " + sKey + " " );
		strpstr += sKey.length + 1;
		thisstr = conjugate( sTemp.substring( strpstr, sTemp.length ) );
		thisstr = strTrim( unpadString(thisstr) )
		if( tempt == "*" ){
			sTemp = replaceStr( rTemp, "<*", " " + thisstr + "?", 0 );
		}
		else {
			sTemp = replaceStr( rTemp, "<@", " " + thisstr + ".", 0 );
		}
	} else sTemp = rTemp;
	return sTemp;
}

/*
 ****************************************************
 * eliza_respond(string):
 * called from eliza_tell to match and output a res-
 * ponse.
 ****************************************************
 */
var wTopic = "";
var sTopic = "";
var wPrevious = "";
var wakeInterval = false;

function eliza_respond(statement)
{
	if ( wakeInterval != null )
	{
		clearInterval( wakeInterval );
	}
	
	wakeInterval = setInterval("eliza_wakeup(true);", 180000);
	
	// test for explanation marks
	if(statement.split("!").length > 2) {
		return phrase( sInput, new entryRef(keywordAngry,0));
	}
		
	// prepare input string
	var sInput = strTrim(statement)

	
	// complain about empty statement
	if ( sInput == "" ) { 
		return phrase("", new entryRef(keywordNoInput,0));
	}
	
	// prepare key
	wInput = padString(sInput.toUpperCase());

	// complain about repeating statements
	if (wInput == wPrevious) {
		return phrase( sInput, new entryRef(keywordRepeat,0));
	}
		
	// save input key string
	wPrevious = wInput;
	
	// search for a key
	var foundkey = - 1;
	foundkey = findKey(wInput);
	
	// no key found. what shall we do?
	if( foundkey == - 1 ) {
		if (( sInput.length < 10 ) &&
				( wTopic != "" ) &&
				( wTopic != wPrevious )) {
			lTopic = sTopic;
			sTopic = "";
			wTopic = "";
			return phrase( lTopic, new entryRef(keywordLeadBack,0));
		}
		if( sInput.length < 15 ) { 
			return phrase( sInput, new entryRef(keywordInputShort,0));
		}
		return phrase( sInput, new entryRef(keywordNotFound,0));
	}
	
	if( sInput.length > 12 ) {
		sTopic = sInput;
		wTopic = wInput;
	}
	return phrase( sInput, foundkey );			// Get our response
}


/*
 ****************************************************
 * eliza_wakeup: display wakeup message
 ****************************************************
 */
function eliza_wakeup()
{
	eliza_write(phrase("",new entryRef(keywordInputDelay,0)),1);
}

loaded = true;
						 
/*
 ****************************************************
 * eliza_hello: say hello
 ****************************************************
 */
function eliza_hello()
{	
	eliza_write(phrase("",new entryRef(keywordSignon,0)),1);
}

/*
 ****************************************************
 * eliza_start: initialize engine
 ****************************************************
 */
function eliza_start()
{
	eliza_setup_lang();

	document.getElementById('ezinput').focus();
	if( loaded ){
		eliza_hello();
	}
	else {
		setTimeout("eliza_start()", 1000);
	}
}

/*
 ****************************************************
 * eliza_delay_response: engine thinks for some time
 ****************************************************
 */
var elizaresponse = "";
function eliza_delay_response()
{
	document.getElementById('ezinput').value = "";
	if( elizaresponse != "" ) {
		eliza_write(elizaresponse,1);
	}		
	else {
		setTimeout("eliza_delay_response()", 250);
	}
}

/*
 ****************************************************
 * eliza_tell: feed next statement to the engine
 ****************************************************
 */
function eliza_tell()
{
	// get input and clear field
	var statement = document.getElementById('ezinput').value;
	document.getElementById('ezinput').value = ""; 


	// find funny characters (<,>)
	// statement = "blabl bla";
	// alert(statement);
	if (statement.indexOf("<") != -1 || statement.indexOf(">") != -1) {
		statement = statement.replace(/</g,"&lt;");
		statement = statement.replace(/>/g,"&gt;");
		elizaresponse = phrase( "", new entryRef(keywordFunnyCharacters,0));
	}
	else {
		elizaresponse = eliza_respond(statement);
	}

	eliza_write(statement,0);
	
	// eliza beginns to think.
	left_thinking(true);

	// delay response according to length of response
	setTimeout("eliza_delay_response()", 1000 + elizaresponse.length*20);
	return false; // don't redraw
}

/*
 ****************************************************
 * HTML OUTPUT AND LOAD FUNCTIONS
 ****************************************************
 */

/*
 ****************************************************
 * left_balloon(content):
 * display a new ballon on the left.
 ****************************************************
 */
var userpic = "";
function left_balloon(content)
{
	var balloon = document.createElement("div");
	balloon.setAttribute("id","balloon_left");
	balloon.innerHTML=
					'<table border="0" cellpadding="0" cellspacing="0"> \
						<tr> \
							<td rowspan="4" valign="bottom"><img src="Images/computer.png" width="32" height="32"></td> \
							<td id="balloon_blue_tl"></td> \
							<td id="balloon_blue_tc"></td> \
							<td id="balloon_blue_tr"></td> \
						</tr><tr> \
							<td id="balloon_blue_ml"></td> \
							<td id="balloon_blue_mc">'
								+ content +
							'</td> \
							<td id="balloon_blue_mr"></td> \
						</tr><tr> \
							<td id="balloon_blue_bl"></td> \
							<td id="balloon_blue_bc"></td> \
							<td id="balloon_blue_br"></td> \
						</tr><tr><td id="balloon_bottom_spacer" colspan="3"></td></tr>\
					</table>';
		return balloon;
}

/*
 ****************************************************
 * left_thinking(thinking):
 * show/hide thinking bubble on the left.
 ****************************************************
 */
function left_thinking(thinking)
{
	var thinkingbubble = document.getElementById('thinking_left');
	if(thinking == true) {
		thinkingbubble.style.display = "block";
		do_refresh();
	}
	else {
		thinkingbubble.style.display = "none";
	}
}

/*
 ****************************************************
 * right_balloon(content):
 * display a new ballon on the right side.
 ****************************************************
 */
function right_balloon(content)
{
	var balloon = document.createElement("div");
	balloon.setAttribute("id","balloon_right");
	balloon.innerHTML=
					' \
					 <table border="0" cellpadding="0" cellspacing="0"> \
						<tr> \
							<td id="balloon_green_tl"></td> \
							<td id="balloon_green_tc"></td> \
							<td id="balloon_green_tr"></td> \
							<td rowspan="4" valign="bottom"><img src="'+userpic+'" width="32" height="32"></td> \
						</tr><tr> \
							<td id="balloon_green_ml"></td> \
							<td id="balloon_green_mc">'
								+ content +
							'</td> \
							<td id="balloon_green_mr"></td> \
						</tr><tr> \
							<td id="balloon_green_bl"></td> \
							<td id="balloon_green_bc"></td> \
							<td id="balloon_green_br"></td> \
						</tr><tr><td id="balloon_bottom_spacer" colspan="3"></td></tr>\
					</table>'
		return balloon;
}

function right_thinking(thinking)
{
	var thinkingbubble = document.getElementById('thinking_right');
	if(thinking == true) {
		thinkingbubble.style.display = "block";
		do_refresh();
	}
	else {
		thinkingbubble.style.display = "none";
	}
}

var scrollbar, scrollArea;


function eliza_restart()
{
	var balloons = document.getElementById('ezlog').childNodes;
	for (i=balloons.length - 1; i>=0; i--) {
		ezlog.removeChild(balloons[i]);
	}
		
	do_refresh();
	
	eliza_hello();
}


/*
 ****************************************************
 *	eliza_write: output one speach bubble
 ****************************************************
 */
function eliza_write(str,who)
{
	var ezlog = document.getElementById('ezlog');
	var balloon;
	if(who==1) {
		left_thinking(false);
		balloon = left_balloon(str);
	}
	else {
		right_thinking(false);
		balloon = right_balloon(str);
	}
	ezlog.appendChild(balloon);
	do_refresh();
}

/*
 ****************************************************
 * do_update_right_thinking():
 * update right thinking bubble regulary (workaround
 * for onkeydown not fitting our needs).
 ****************************************************
 */
var thinkUpdateInterval = false;
function do_update_right_thinking()
{
	if ( thinkUpdateInterval != null )
	{
		clearInterval( thinkUpdateInterval );
		thinkUpdateInterval = null;
	}
	
	right_thinking(document.getElementById('ezinput').value != "");
	
	thinkUpdateInterval = setInterval("do_update_right_thinking();", 500);
}

/*
 ****************************************************
 *	onshow():
 ****************************************************
 */
function onshow () {
	if ( wakeInterval != null )
	{
		clearInterval( wakeInterval );
		wakeInterval = null;
	}
	if ( thinkUpdateInterval != null )
	{
		clearInterval( thinkUpdateInterval );
		thinkUpdateInterval = null;
	}
	do_update_right_thinking();
}

/*
 ****************************************************
 *	onhide():
 ****************************************************
 */
function onhide () {
	if ( wakeInterval != null )
	{
		clearInterval( wakeInterval );
		wakeInterval = null;
	}
	if ( thinkUpdateInterval != null )
	{
		clearInterval( thinkUpdateInterval );
		thinkUpdateInterval = null;
	}
}

if (window.widget) {
	//data = widget.preferenceForKey("locale");
	widget.onhide = onhide;
	widget.onshow = onshow;
}

/*
 ****************************************************
 * do_refresh: scroll to the end of the log and
 * update content and scroll bars.
 ****************************************************
 */
function do_refresh() {
	scrollArea.verticalScrollTo(scrollArea.content.scrollHeight - scrollArea.viewHeight);
	scrollArea.refresh();
}

/*
 ****************************************************
 * do_load: initialize widget
 ****************************************************
 */
function do_load() {
	// setup apple widget
	scrollbar = new AppleVerticalScrollbar(document.getElementById("myScrollBar"));
	scrollArea = new AppleScrollArea(document.getElementById("parentDiv"), scrollbar);
	scrollArea.scrollsHorizontally = false;
	scrollArea.singlepressScrollPixels = 25;
	scrollArea.focus(); // for key control when first loading in Safari
	
	// connect events
	window.onfocus = function () { scrollArea.focus(); }
	window.onblur = function () { scrollArea.blur(); }
		
	sv = document.getElementById('scrollView')
	sv.style.display = 'block';
	scrollArea.reveal(sv);
	
	// seed random
	now = new Date();
	seed = now.getSeconds();
	Math.random(seed);
	
	// get user picture
	if (window.widget && widget.system) {
		userpic = "file:///" + widget.system("/usr/bin/niutil -readprop . /users/$(whoami) picture",null).outputString;
	}
	else {
		userpic = "file:///Library/User Pictures/Animals/Dog.tif";
	}
	document.getElementById('user_image').src = userpic;
	
	
	
	// done button
	var doneButton = document.getElementById("done");
	createGenericButton(doneButton, "Done", hideBack);
	
	// fire up bubble timer
	do_update_right_thinking();

	// fire up the engine
	eliza_start();

	
	return;
}

/*
 ****************************************************
 * openWebsite(event,site): show me the website
 ****************************************************
 */
function openWebsite(event,site)
{
	if (window.widget)
	{
		widget.openURL(site);
	}
}

/*
 ****************************************************
 * showBack(): show your back!
 ****************************************************
 */
function showBack()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
 
    if (window.widget)
        widget.prepareForTransition("ToBack");
 
    front.style.display="none";
    back.style.display="block";
 
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);  
}

/*
 ****************************************************
 * hideBack(): be nice again
 ****************************************************
 */
function hideBack()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
 
    if (window.widget)
        widget.prepareForTransition("ToFront");
 
    back.style.display="none";
    front.style.display="block";
 
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
}


/*
 ****************************************************
 * flipping support stuff here
 ****************************************************
 */
var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};
 
function mousemove (event)
{
    if (!flipShown)
    {
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
 
        var starttime = (new Date).getTime() - 13;
 
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 1.0;
        animate();
        flipShown = true;
    }
}
 
function mouseexit (event)
{
    if (flipShown)
    {
        // fade in the info button
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
 
        var starttime = (new Date).getTime() - 13;
 
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 0.0;
        animate();
        flipShown = false;
    }
}
 
function animate()
{
    var T;
    var ease;
    var time = (new Date).getTime();
 
 
    T = limit_3(time-animation.starttime, 0, animation.duration);
 
    if (T >= animation.duration)
    {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    }
    else
    {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
 
    animation.firstElement.style.opacity = animation.now;
}
 
function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}
 
function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function enterflip(event)
{
    document.getElementById('fliprollie').style.display = 'block';
}
 
function exitflip(event)
{
    document.getElementById('fliprollie').style.display = 'none';
}