//-----------------------------------------------------------------------------
//  Holiday.js is part of the BART dashboard widget.  (c) 2005 Bret Victor
//  This software is licensed under the terms of the open source MIT license.
//-----------------------------------------------------------------------------
//
//  Service Levels -- http://www.bart.gov/guide/holidays.aspx
//
//  Automatically generated by make_holiday.pl on Mon Nov  5 20:37:04 2018.
//

function Holiday () {

    servicelevel = {}
    servicelevel['11/24/2016'] = 'sunday'
    servicelevel['12/25/2016'] = 'sunday'
    servicelevel['01/01/2017'] = 'sunday'
    servicelevel['01/16/2017'] = 'saturday'
    servicelevel['02/20/2017'] = 'saturday'
    servicelevel['05/29/2017'] = 'sunday'
    servicelevel['07/04/2017'] = 'sunday'
    servicelevel['09/04/2017'] = 'sunday'
    servicelevel['11/23/2017'] = 'sunday'
    servicelevel['12/25/2017'] = 'sunday'
    servicelevel['01/01/2018'] = 'sunday'
    servicelevel['01/15/2018'] = 'saturday'
    servicelevel['02/19/2018'] = 'saturday'
    servicelevel['05/28/2018'] = 'sunday'
    servicelevel['07/04/2018'] = 'sunday'
    servicelevel['09/03/2018'] = 'sunday'
    servicelevel['11/22/2018'] = 'sunday'
    servicelevel['12/25/2018'] = 'sunday'
    servicelevel['01/01/2019'] = 'sunday'
    
    Holiday.getServiceLevel = function(date) {
        var date_string = date.toMMDDYYYYString()
        var day_of_week = date.getDay()
        
        return servicelevel[date_string] ||
            ( (day_of_week == 0)        ? 'sunday'
            : (day_of_week == 6)        ? 'saturday'
            :                             'weekday')
    }
}

// Open the package.
Holiday();

